// ----------------------------------------------------------------------------------



#include "CPhone.h"
#include "UError.h"
#include <string.h>

//#define TEST
//#define TRACE


inline
void ClearEndTab(char *Word)
{	short len = strlen(Word) -1;
	Word[len] = '\0';

}

inline
void InsertEndTab(char *Word)
{	short len = strlen(Word) -1;
	Word[len] = '\t';
	Word[len+1] = '\0';

}

void
CPhoneme::First(CMainDict *Dict, short Initial_Phoneme, char *Word)
{
	#ifdef TRACE
	printf("\nPhoneme::FindFirstWord()");
	#endif
	// assert((Initial_Phoneme > 0) && (Initial_Phoneme <= 26));
	CurrentInitialPhoneme = Start(Initial_Phoneme,&InitialPhonemeLength);
	//Dict->location.CurrentWord[0]= NULL;
	Dict->Find(CurrentInitialPhoneme);
	Dict->Current(Word);

}

short
CPhoneme::Next(CMainDict *Dict, char *Word)
{
	short Result;
	
	#ifdef TRACE
	printf("\nPhoneme::NextWordPossibility()");
	#endif
	
	// assert (((Dict != NULL) && ((InitialPhoneme > 0) && (InitialPhoneme <= 26))));
	Result = Dict->Next(Word);
	
	if ((Result == EOI) || (Result < eNo_Err)) 
		return (DONE);
	
		
	/* Check to see if the Initial Phoneme matches
	If it doesn't, get the next phoneme.  */
	
	if  (strncmp(Word,CurrentInitialPhoneme,InitialPhonemeLength) != 0) 
	{
		CurrentInitialPhoneme = NextPhoneme(&InitialPhonemeLength);
		if(InitialPhonemeLength == 0) return (DONE);
		
		Dict->Find(CurrentInitialPhoneme);
		Dict->Current(PossibleSuggestion);
	}
		
	
	if (ErrorFunc(0, GET) < eNo_Err)
	{	return (DONE);
	}

	return (OK);
}


void 
CPhoneme::CreateFilter(char *Word)
{
    CreatePhonPattern(Word);
}

short
CPhoneme::PhoneticTestWord(char *Word)
{
   return (PhonTestWord(Word));
}

// ----------------------------------------------------------------------------------
//
// ----------------------------------------------------------------------------------
//
// PhonPatter - word to search, Word -- suggestion

short
CPhoneme::FirstSuggestion(CMainDict *Dict, char *PhonPattern, char *Word, CallBackProc CallBack)
{
	char *EndOfWord;
	short Result;
	short i = 0;

     if(strlen(Word) > 30) return FALSE;

	// make sure it is an English dictionary
	if (!Dict->Find("ENGLISH"))
		return FALSE;

	#ifdef TRACE
	printf("\nPhoneme::GetFirstPhonemeSuggestion()");
	#endif

	CreatePhonPattern(PhonPattern);
	this->First(Dict, InitialPhoneme,PossibleSuggestion);
	do {
		if(PhonTestWord(PossibleSuggestion) == MATCH) {

			EndOfWord = strchr(PossibleSuggestion,0x09);
			if	(EndOfWord != NULL)
				*EndOfWord = 0;
			ClearEndTab(PhonPattern);
			strcpy(Word,PossibleSuggestion);
			return FOUND;
		}



		Result = this->Next(Dict,PossibleSuggestion);

		if (!((i++) % 17))
		{
			if ((CallBack != NULL) && (*CallBack)())
				ErrorFunc(eCancel, SET);

			#ifdef _MACINTOSH_
			//SystemTask();
			#endif
		}

	} while((Result != DONE) && !ErrorFunc(0, GET));

	ClearEndTab(PhonPattern);

	return NOTFOUND;
}


short
CPhoneme::NextSuggestion(CMainDict *Dict, char *PhonPattern, char *Word, CallBackProc CallBack)
{
	char *EndOfWord;
	short i=5;

	if(strlen(Word) > 30) return FALSE;

	#ifdef TRACE
	printf("\nPhoneme::GetNextPhonemeSuggestion()");
	#endif

	InsertEndTab(PhonPattern);

	short Result = this->Next(Dict, PossibleSuggestion);
	do{
		if( PhonTestWord(PossibleSuggestion) == MATCH) 
		{
			EndOfWord = strchr(PossibleSuggestion,0x09);
			if (EndOfWord != NULL) 
				*EndOfWord = 0;
			ClearEndTab(PhonPattern);
			strcpy(Word,PossibleSuggestion);
			// RETURN SOMETHING
			break;
		}
		

		Result = this->Next(Dict,PossibleSuggestion);
		
		if (!((i++) % 17))
		{
			if ((CallBack != NULL) && (*CallBack)())
				ErrorFunc(eCancel, SET);
			
			#ifdef _MACINTOSH_
			//SystemTask();
			#endif
		}
			
	} while( (Result != DONE) && !ErrorFunc(0, GET));
	
	ClearEndTab(PhonPattern);
	return DONE;
}





CPhoneme::CPhoneme()
	:UParser(), USound()
{
	// PhonemeWordList = new ULinkedList;
}

CPhoneme::~CPhoneme()
{
	// delete PhonemeWordList;
}


#ifdef TEST

void main()
{

     char DictName[20];
     char UserDictName[20];
     short  DocWordSize;
     short  UserWordSize;
     short  SkipWordSize;
     short  NumBuffers;

     short  CurrentNibble;
     char Choice[50];
     short  Result;
     short  TestResult;
     CMainDict *Dict;

     CPhoneme Phon;

     for(;;) {
       printf("\n1) Make a Word Pattern");
       printf("\n2) Find suggestions for current pattern");
       printf("\n3) Open Dictionary");
       printf("\n4) Phoneticly test word against pattern");
       printf("\n0) Quit\n");
       gets(Choice);
       Result = atoi(Choice);
       switch(Result) {
	case 1:
		printf("\nWord :");
		gets(Choice);
		Phon.CreateFilter(Choice);
		printf("\nO.K. Pattern Done ....");
		break;

	case 2:
		printf("\nWord :");
		gets(Choice);
		Phon.Suggestions(Dict,Choice);
		break;

	case 3:
		printf("\nDictionary Name :");
		gets(DictName);
		printf("\nNumber of Buffers [15] :");
		gets(Choice);
		NumBuffers = atoi(Choice);
		if(NumBuffers == 0) {NumBuffers = 15; printf("Buffers = %d",NumBuffers); }
		Dict = new CMainDict(NumBuffers, DictName);
		if(Dict == NULL) printf("\n\a\aError Opening Dictionary....");

		/*printf("\nDictionary Name :");
		gets(DictName);
		printf("\nUser Dictionary Name :");
		gets(UserDictName);
		printf("\nDocument Word Cache Size :");
		gets(Choice);
		DocWordSize = atoi(Choice);
		printf("\nUser Word Cache Size :");
		gets(Choice);
		printf("\nSkip Word Cache Size :");
		gets(Choice);
		SkipWordSize = atoi(Choice);
		UserWordSize = atoi(Choice);
		printf("\nNumber of Buffers :");
		gets(Choice);
		NumBuffers = atoi(Choice);

		Dict = OpenDictionary(DictName,UserDictName,DocWordSize,UserWordSize,SkipWordSize,NumBuffers);
		if(Dict == NULL) printf("\n\a\aError Opening Dictionary....");
		*/
		break;

	case 4:
		printf("\nWord To Test :");
		gets(Choice);
		TestResult = Phon.PhoneticTestWord(Choice);
		if(TestResult == MATCH) printf("\nMatch");
		else printf("\n Not Match : Test Result = %d",TestResult);
		break;

	case 0: exit(1);
		break;
       }
     }
    }

#endif

